<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Careers extends Admin_Core_Controller
{
    public function __construct()
    {
        parent::__construct();

        //check auth
        if (!is_admin()) {
            redirect('login');
        }
    }
    public function add_careers()
    {
         $this->load->model("careers_model");
        $data['title'] = "Add Careers";
        $data['menu_links'] = $this->navigation_model->get_menu_links();

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/careers/add', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Add Page Post
     */
    public function add_careers_post()
    {
        //validate inputs
        $this->load->model("careers_model");
        $this->form_validation->set_rules('job_title', "Job Title", 'required|xss_clean|max_length[500]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->careers_model->input_values());
            redirect($this->agent->referrer());
        } else {
            if ($this->careers_model->add()) {
                $this->session->set_flashdata('success', "Careers" . " " . trans("msg_suc_added"));
                redirect($this->agent->referrer());
            } else {
                $this->session->set_flashdata('form_data', $this->careers_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Pages
     */
    public function careers()
    {
        $this->load->model("careers_model");
        $data['title'] = "Careers";
        $data['pages'] = $this->careers_model->get_all_careers();
        $data['lang_search_column'] = 2;

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/careers/careers', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Page
     */
    public function update_careers($id)
    {
        $this->load->model("careers_model");
        $data['title'] = "Update Careers";

        //find page
        $data['page'] = $this->careers_model->get_careers_by_id($id);

        //page not found
        if (empty($data['page'])) {
            redirect($this->agent->referrer());
        }
        //$data['menu_links'] = $this->navigation_model->get_menu_links_by_lang($data['page']->lang_id);

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/careers/update', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Page Post
     */
    public function update_careers_post()
    {
         $this->load->model("careers_model");
        //validate inputs
        $this->form_validation->set_rules('job_title', trans("title"), 'required|xss_clean|max_length[500]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->careers_model->input_values());
            redirect($this->agent->referrer());
        } else {
            //get id
            $id = $this->input->post('id', true);
            $redirect_url = $this->input->post('redirect_url', true);

            if ($this->careers_model->update($id)) {
                $this->session->set_flashdata('success',"Careers" . " " . trans("msg_suc_updated"));

                if (!empty($redirect_url)) {
                    redirect($redirect_url);
                } else {
                    redirect('careers/careers');
                }
            } else {
                $this->session->set_flashdata('form_data', $this->careers_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Delete Page Post
     */
    public function delete_careers_post()
    {
       $this->load->model("careers_model");
        $id = $this->input->post('id', true);

        $page = $this->careers_model->get_careers_by_id($id);

        if (empty($page)) {
            redirect($this->agent->referrer());
        }

        if ($this->careers_model->delete($id)) {
            $this->session->set_flashdata('success', "Careers" . " " . trans("msg_suc_deleted"));
            redirect($this->agent->referrer());
        } else {
            $this->session->set_flashdata('error', trans("msg_error"));
            redirect($this->agent->referrer());
        }
    }


}