<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clients extends Admin_Core_Controller
{

    public function __construct()
    {
        parent::__construct();

        //check auth
        if (!is_admin()) {
            redirect('login');
        }
    }


    /**
     * Gallery
     */
    public function clients()
    {
        $this->load->model("clients_model");
        $data['title'] = "Clients";
        $data['images'] = $this->clients_model->get_all_images();
        //$data['categories'] = $this->gallery_category_model->get_categories();
        $data['lang_search_column'] = 3;

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/clients/clients', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Add Image Post
     */
    public function add_clients_image_post()
    {
        //validate inputs
          $this->load->model("clients_model");
        $this->form_validation->set_rules('title', trans("title"), 'xss_clean|max_length[500]');
        //$this->form_validation->set_rules('category_id', trans("category"), 'required');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors_form', validation_errors());
            $this->session->set_flashdata('form_data', $this->clients_model->input_values());
            redirect($this->agent->referrer());
        } else {
            if ($this->clients_model->add()) {
                $this->session->set_flashdata('success_form', "Client Logo" . " " . trans("msg_suc_added"));
                redirect($this->agent->referrer());
            } else {
                $this->session->set_flashdata('form_data', $this->clients_model->input_values());
                $this->session->set_flashdata('error_form', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Update Image
     */
    public function update_clients_image($id)
    {
        $data['title'] = trans("update_image");
       $this->load->model("clients_model");
        //get post
        $data['image'] = $this->clients_model->get_image($id);

        if (empty($data['image'])) {
            redirect($this->agent->referrer());
        }

        //$data['categories'] = $this->gallery_category_model->get_categories_by_lang($data['image']->lang_id);

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/clients/update', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Image Post
     */
    public function update_clients_image_post()
    {
        //validate inputs
        $this->load->model("clients_model");
        $this->form_validation->set_rules('title', trans("title"), 'xss_clean|max_length[500]');
       // $this->form_validation->set_rules('category_id', trans("category"), 'required');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->clients_model->input_values());
            redirect($this->agent->referrer());
        } else {

            $id = $this->input->post('id', true);

            if ($this->clients_model->update($id)) {
                $this->session->set_flashdata('success', "Clients Logo" . " " . trans("msg_suc_updated"));
                redirect('clients/clients');
            } else {
                $this->session->set_flashdata('form_data', $this->clients_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Delete Image Post
     */
    public function delete_clients_image_post()
    {
        $id = $this->input->post('id', true);
$this->load->model("clients_model");
        if ($this->clients_model->delete($id)) {
            $this->session->set_flashdata('success', trans("image") . " " . trans("msg_suc_deleted"));
            redirect($this->agent->referrer());
        } else {
            $this->session->set_flashdata('error', trans("msg_error"));
            redirect($this->agent->referrer());
        }
    }


}
