<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Feedback extends Admin_Core_Controller
{
    public function __construct()
    {
        parent::__construct();

        //check auth
        if (!is_admin()) {
            redirect('login');
        }
    }


    /**
     * Add Page
     */
    public function add_feedback()
    {
        $data['title'] = "Add Feedback";
        $data['menu_links'] = $this->navigation_model->get_menu_links();

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/feedback/add', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Add Page Post
     */
    public function add_feedback_post()
    {
        //validate inputs
        $this->load->model("feedback_model");
        $this->form_validation->set_rules('title', trans("title"), 'xss_clean|max_length[500]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->feedback_model->input_values());
            redirect($this->agent->referrer());
        } else {
            if ($this->feedback_model->add()) {
                $this->session->set_flashdata('success', "Feedback" . " " . trans("msg_suc_added"));
                redirect($this->agent->referrer());
            } else {
                $this->session->set_flashdata('form_data', $this->feedback_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Pages
     */
    public function feedback()
    {
         $this->load->model("feedback_model");
        $data['title'] = "Feedback";
        $data['pages'] = $this->feedback_model->get_all_feedback();
        $data['lang_search_column'] = 2;

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/feedback/feedback', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Page
     */
    public function update_feedback($id)
    {
         $this->load->model("feedback_model");
        $data['title'] = "Update Feedback";

        //find page
        $data['page'] = $this->feedback_model->get_feedback_by_id($id);

        //page not found
        if (empty($data['page'])) {
            redirect($this->agent->referrer());
        }
        //$data['menu_links'] = $this->navigation_model->get_menu_links_by_lang($data['page']->lang_id);

        $this->load->view('admin/includes/_header', $data);
        $this->load->view('admin/feedback/update', $data);
        $this->load->view('admin/includes/_footer');
    }


    /**
     * Update Page Post
     */
    public function update_feedback_post()
    {
         $this->load->model("feedback_model");
        //validate inputs
        $this->form_validation->set_rules('title', trans("title"), 'xss_clean|max_length[500]');

        if ($this->form_validation->run() === false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->session->set_flashdata('form_data', $this->feedback_model->input_values());
            redirect($this->agent->referrer());
        } else {
            //get id
            $id = $this->input->post('id', true);
            $redirect_url = $this->input->post('redirect_url', true);

            if ($this->feedback_model->update($id)) {
                $this->session->set_flashdata('success',"Feedback" . " " . trans("msg_suc_updated"));

                if (!empty($redirect_url)) {
                    redirect($redirect_url);
                } else {
                    redirect('feedback/feedback');
                }
            } else {
                $this->session->set_flashdata('form_data', $this->feedback_model->input_values());
                $this->session->set_flashdata('error', trans("msg_error"));
                redirect($this->agent->referrer());
            }
        }
    }


    /**
     * Delete Page Post
     */
    public function delete_feedback_post()
    {
       $this->load->model("feedback_model");
        $id = $this->input->post('id', true);

        $page = $this->feedback_model->get_feedback_by_id($id);

        if (empty($page)) {
            redirect($this->agent->referrer());
        }

        if ($this->feedback_model->delete($id)) {
            $this->session->set_flashdata('success', "Feedback" . " " . trans("msg_suc_deleted"));
            redirect($this->agent->referrer());
        } else {
            $this->session->set_flashdata('error', trans("msg_error"));
            redirect($this->agent->referrer());
        }
    }


}