<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Careers_model extends CI_Model
{
    //input values
    public function input_values()
    {
        $data = array(
             'job_title' => $this->input->post('job_title', true),
            'button_name' => $this->input->post('button_name', true),
            'job_description' => $this->input->post('job_description', false),
            'visibility' => $this->input->post('visibility', true),
        );
        return $data;
    }

    //add page
    public function add()
    {
        $data = $this->careers_model->input_values();
        return $this->db->insert('careers', $data);
    }

    //update page
    public function update($id)
    {
        //set values
        $data = $this->careers_model->input_values();
        $page = $this->get_careers_by_id($id);
        if (!empty($page)) {
            $this->db->where('id', $id);
            return $this->db->update('careers', $data);
        }
        return false;
    }

    //get all pages
    public function get_all_careers()
    {
        $this->db->order_by('id');
        $query = $this->db->get('careers');
        return $query->result();
    }

    //get pages
     public function get_careers_applied()
    {
        $query = $this->db->get('careers_applied');
        return $query->result();
    }
     public function delete_careers_applied($id)
    {
        $this->db->where('id', $id);
        return $this->db->delete('careers_applied');
    }
    public function get_careers()
    {
      //  $this->db->where('feedback.lang_id', $this->selected_lang->id);
        $query = $this->db->get('careers');
        return $query->result();
    }
    //get page by id
    public function get_careers_by_id($id)
    {
        $this->db->where('id', $id);
        $query = $this->db->get('careers');
        return $query->row();
    }
    //delete page
    public function delete($id)
    {
        $page = $this->get_careers_by_id($id);
        if (!empty($page)) {

            $this->db->where('id', $id);
            return $this->db->delete('careers');
        }
        return false;
    }
}