<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Feedback_model extends CI_Model
{
    //input values
    public function input_values()
    {
        $data = array(
             'title' => $this->input->post('title', true),
            'name' => $this->input->post('name', true),
            'email_id' => $this->input->post('email_id', true),
            'mobile_no' => $this->input->post('mobile_no', true),
            'subject' => $this->input->post('subject', true),
            'content' => $this->input->post('content', false),
            'visibility' => $this->input->post('visibility', true),
        );
        return $data;
    }

    //add page
    public function add()
    {
        $data = $this->feedback_model->input_values();
        return $this->db->insert('feedback', $data);
    }

    //update page
    public function update($id)
    {
        //set values
        $data = $this->feedback_model->input_values();
        $page = $this->get_feedback_by_id($id);
        if (!empty($page)) {
            $this->db->where('id', $id);
            return $this->db->update('feedback', $data);
        }
        return false;
    }

    //get all pages
    public function get_all_feedback()
    {
        $this->db->order_by('id');
        $query = $this->db->get('feedback');
        return $query->result();
    }

    //get pages
    public function get_feedbacks()
    {
      //  $this->db->where('feedback.lang_id', $this->selected_lang->id);
        $query = $this->db->get('feedback');
        return $query->result();
    }
    //get page
    public function get_feedback($slug)
    {
       // $this->db->where('slug', $slug);
        $query = $this->db->get('feedback');
        return $query->row();
    }

    //get page by lang
    public function get_page_by_lang($slug, $lang_id)
    {
       // $this->db->where('lang_id', $lang_id);
       // $this->db->where('slug', $slug);
        $query = $this->db->get('pages');
        return $query->row();
    }

    //get page by id
    public function get_feedback_by_id($id)
    {
        $this->db->where('id', $id);
        $query = $this->db->get('feedback');
        return $query->row();
    }

   

    //delete page
    public function delete($id)
    {
        $page = $this->get_feedback_by_id($id);
        if (!empty($page)) {

            $this->db->where('id', $id);
            return $this->db->delete('feedback');
        }
        return false;
    }
}