<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Testimonials_admin_model extends CI_Model
{

    //input values
    public function input_values()
    {
        $data = array(
            'page_title' => $this->input->post('page_title', true),
            'name' => $this->input->post('name', true),
            'designation' => $this->input->post('designation', true),
            'description' => $this->input->post('description', false),
            'visibility' => $this->input->post('visibility', true),
        );
        return $data;
    }

    //add post
    public function add_testimonials()
    {
         $this->load->model("testimonials_model");
        $data = $this->set_data();
        $date_published = $this->input->post('date_published', true);
        if (!empty($date_published)) {
            $data["created_at"] = $date_published;
        }

       // $data['user_id'] = user()->id;
        $data['status'] = $this->input->post('status', true);

        return $this->db->insert('testimonials', $data);
    }

    //update post
    public function update_testimonials($id)
    {
         $this->load->model("testimonials_model");
        $data = $this->set_data();

        $data["created_at"] = $this->input->post('date_published', true);

        $publish = $this->input->post('publish', true);
        if (!empty($publish) && $publish == 1) {
            $data["status"] = 1;
        }

        //if author set visibility
        if (is_author()) {
            $data['visibility'] = 0;
        }

        $this->db->where('id', $id);
        return $this->db->update('testimonials', $data);
    }

    //set post data
    public function set_data()
    {
        $data = $this->input_values();
        if (empty($this->input->post('image_url', true))):
            //add post image
             $image = $this->file_model->get_image($this->input->post('post_image_id', true));
            if (!empty($image)) {
                $data["image"] = $image->image_small;
              //  //$data["image_mid"] = $image->image_mid;
                //$data["image_small"] = $image->image_small;
               // $data["image_slider"] = $image->image_slider;
            }
        endif;

        return $data;

    }
    //get post
    public function get_testimonials($id)
    {
        $this->db->where('testimonials.id', $id);
        $query = $this->db->get('testimonials');
        return $query->row();
    }
    //get paginated posts
    public function get_paginated_testimonials($per_page, $offset, $list)
    {
       // $this->filter_posts();
       // $this->filter_posts_list($list);
        $this->db->where('testimonials.visibility', 1);
        $this->db->where('testimonials.status', 1);
        $this->db->order_by('testimonials.created_at', 'DESC');
        $this->db->limit($per_page, $offset);
        $query = $this->db->get('testimonials');
        return $query->result();
    }

    //get paginated posts count
    public function get_paginated_testimonials_count($list)
    {
        //$this->filter_posts();
        //$this->filter_posts_list($list);
        $this->db->where('testimonials.visibility', 1);
        $this->db->where('testimonials.status', 1);
        $query = $this->db->get('testimonials');
        return $query->num_rows();
    }
    //delete post
    public function delete_testimonials($id)
    {
        $post = $this->get_testimonials($id);

        if (!empty($post)):
            $this->db->where('id', $id);
            return $this->db->delete('testimonials');
        else:
            return false;
        endif;
    }

    //delete multi post
    public function delete_multi_testimonials($post_ids)
    {
        if (!empty($post_ids)) {
            foreach ($post_ids as $id) {
                $post = $this->get_testimonials($id);

                if (!empty($post)) {

                    //delete post tags
                   // $this->tag_model->delete_post_tags($id);

                    $this->db->where('id', $id);
                    $this->db->delete('testimonials');
                }
            }
        }

    }
}